#include <iostream>
#include <unordered_map>
#include <string>
#include <vector>

using namespace std;

int main() {
    enum {
        O = 0,
        A = 1,
        B = 2,
        AB = 3
    };

    int n;
    cin >> n;
    
    int o, a, b, ab;
    cin >> o >> a >> b >> ab;

    struct Pacijent {
        int redni_broj;
        int jedinica;
    };

    unordered_map<int, vector<Pacijent>> pacijenti;
    for (int i = 0; i < n; i++) {
        string krvna_grupa;
        cin >> krvna_grupa;

        int indeks_grupe = O;
        if (krvna_grupa == "A")
            indeks_grupe = A;
        else if (krvna_grupa == "B")
            indeks_grupe = B;
        else if (krvna_grupa == "AB")
            indeks_grupe = AB;

        Pacijent pacijent;
        pacijent.redni_broj = i;
        cin >> pacijent.jedinica;
        pacijenti[indeks_grupe].push_back(pacijent);
    }

    vector<int[4]> transfuzije(n);

    auto rasporedi = [&] (const int grupa_pacijenta) {
        while (pacijenti[grupa_pacijenta].size() > 0) {
            Pacijent pacijent = pacijenti[grupa_pacijenta].back();
            pacijenti[grupa_pacijenta].pop_back();
            int* transfuzija = transfuzije[pacijent.redni_broj];

            switch (grupa_pacijenta) {
            case O:
                transfuzija[O] = pacijent.jedinica;
                o -= pacijent.jedinica;
                break;
            case A:
                transfuzija[A] = min(a, pacijent.jedinica);
                a -= transfuzija[A];
                transfuzija[O] = pacijent.jedinica - transfuzija[A];
                o -= transfuzija[O];
                break;
            case B:
                transfuzija[B] = min(b, pacijent.jedinica);
                b -= transfuzija[B];
                transfuzija[O] = pacijent.jedinica - transfuzija[B];
                o -= transfuzija[O];
                break;
            case AB:
                transfuzija[AB] = min(ab, pacijent.jedinica);
                ab -= transfuzija[AB];
                pacijent.jedinica -= transfuzija[AB];
                transfuzija[B] = min(b, pacijent.jedinica);
                b -= transfuzija[B];
                pacijent.jedinica -= transfuzija[B];
                transfuzija[A] = min(a, pacijent.jedinica);
                a -= transfuzija[A];
                transfuzija[O] = pacijent.jedinica - transfuzija[A];
                o -= transfuzija[O];
            }
        }
    };

    rasporedi(O);
    rasporedi(A);
    rasporedi(B);
    rasporedi(AB);

    if (o < 0 || a < 0 || b < 0 || ab < 0)
        cout << "nemoguce" << endl;
    else {
        cout << "moguce" << endl;
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < 4; j++)
                cout << transfuzije[i][j] << " ";
            cout << endl;
        }
    }
    return 0;
}